---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-iostat - I/O統計レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/iostat/iostat.c` 120-148行目（nlist定義、グローバル変数）
- E-02: `usr.sbin/iostat/iostat.c` 177-649行目（main関数）
- E-03: `usr.sbin/iostat/iostat.c` 720-780行目（phdr関数）
- E-04: `usr.sbin/iostat/iostat.c` 782-980行目（devstats関数）
- E-05: `usr.sbin/iostat/iostat.c` 982-995行目（cpustats関数）
- E-06: `usr.sbin/iostat/iostat.c` 162-175行目（usage関数）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | devstat APIでカーネルI/O統計を取得 | E-02 (334行目: devstat_getdevs, 832行目: devstat_compute_statistics) | ○ |
| C-02 | -xオプションで拡張出力モード | E-04 (800-821行目) | ○ |
| C-03 | -Tオプションで TTY統計表示 | E-02 (477-483行目), E-03 (733-756行目) | ○ |
| C-04 | -Cオプションで CPU統計表示 | E-02 (486-500行目), E-05 | ○ |
| C-05 | SIGALRMベースのタイマー待機 | E-02 (463-468行目: setitimer) | ○ |
| C-06 | SIGWINCHで端末サイズ動的更新 | E-02 (447行目: signal(SIGWINCH, needresize)) | ○ |
| C-07 | -zオプションでゼロI/Oデバイスをスキップ | E-04 (881-885行目) | ○ |
| C-08 | -Iオプションで累積値表示 | E-01 (146行目: Iflag), E-04 (886行目以降) | ○ |
| C-09 | etime=0の場合1.0に補正 | E-02 (605-606行目) | ○ |
| C-10 | SIGINTで終了時に最終統計出力 | E-02 (457行目: signal(SIGINT, needreturn), 629行目) | ○ |
| C-11 | -hオプションでトップモード（ビジーデバイス優先） | E-02 (566-592行目) | ○ |
| C-12 | デバイス名は device_name + unit_number で構成 | E-03 (740-742行目), E-04 (874-876行目) | ○ |
| C-13 | CPU使用率はrint()で丸め | E-05 (993行目) | ○ |
| C-14 | devstat_checkversion()でバージョン確認 | E-02 (284行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 単一ファイルで完結しており、全処理をソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] devstat APIのバージョン互換性を確認
- [ ] -Kオプション（KB単位ブロック表示）の動作を確認
- [ ] 旧形式(-o)出力フォーマットとの後方互換性を確認
